<?php
class vb_optimise_wincache extends vb_optimise_operator
{
	public function connect()
	{
		if (!function_exists('wincache_ucache_get'))
		{
			return false;
		}

		return true;
	}

	public function get($id = '')
	{
		if (!$this->connect())
		{
			return false;
		}

		return $this->handle_blank(wincache_ucache_get($this->id($id)));
	}

	public function set($id = '', $value = '')
	{
		if (!$this->connect())
		{
			return false;
		}

		if (!is_array($value) && trim($value) == '')
		{
			$value = '{VBO_BLANK}';
		}

		wincache_ucache_set($this->id($id), $value);
	}

	public function do_flush($silent = false)
	{
		global $vbulletin;

		wincache_ucache_clear();
	}
}
?>